<?php
\session_start();

require '../bootstrap.php';

const CURRENT_VERSION = '1.0.1';

const APP_CLIENT_URL = SERVER_URL . ADMIN_CLIENT_DIR_NAME . '/build/';

?>

<!DOCTYPE html>

<html>

<head>
    <title>Admin Panel</title>

    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="scaffolded-by" content="https://github.com/dart-lang/sdk">
    <meta name="theme-color" content="#000000">
    <meta name="msapplication-navbutton-color" content="#000000">
    <meta name="apple-mobile-web-app-status-bar-style" content="#000000">

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css" integrity="sha256-eZrrJcwDc/3uDhsdt61sL2oOBY362qM3lon1gyExkL0=" crossorigin="anonymous">

    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&amp;display=swap" rel="stylesheet">

    <!-- app -->

    <link href="<?php echo APP_CLIENT_URL; ?>css/main.css" rel="stylesheet">

    <link href="<?php echo APP_CLIENT_URL; ?>include/halfmoon-1.1.1/css/halfmoon.min.css" rel="stylesheet">
    <link href="<?php echo APP_CLIENT_URL; ?>include/animate/animate.min.css" rel="stylesheet">

    <script defer src="<?php echo APP_CLIENT_URL; ?>main.dart.js"></script>

    <script defer src="<?php echo APP_CLIENT_URL; ?>include/halfmoon-1.1.1/js/halfmoon.min.js"></script>
    <script defer src="<?php echo APP_CLIENT_URL; ?>include/chartjs/chartjs.js"></script>

    <style>
        .animate__animated {
            --animate-duration: 0.5s;
        }
    </style>

    <!-- favicon -->

    <link rel="apple-touch-icon" sizes="57x57" href="<?php echo APP_CLIENT_URL; ?>favicon/apple-icon-57x57.png">
    <link rel="apple-touch-icon" sizes="60x60" href="<?php echo APP_CLIENT_URL; ?>favicon/apple-icon-60x60.png">
    <link rel="apple-touch-icon" sizes="72x72" href="<?php echo APP_CLIENT_URL; ?>favicon/apple-icon-72x72.png">
    <link rel="apple-touch-icon" sizes="76x76" href="<?php echo APP_CLIENT_URL; ?>favicon/apple-icon-76x76.png">
    <link rel="apple-touch-icon" sizes="114x114" href="<?php echo APP_CLIENT_URL; ?>favicon/apple-icon-114x114.png">
    <link rel="apple-touch-icon" sizes="120x120" href="<?php echo APP_CLIENT_URL; ?>favicon/apple-icon-120x120.png">
    <link rel="apple-touch-icon" sizes="144x144" href="<?php echo APP_CLIENT_URL; ?>favicon/apple-icon-144x144.png">
    <link rel="apple-touch-icon" sizes="152x152" href="<?php echo APP_CLIENT_URL; ?>favicon/apple-icon-152x152.png">
    <link rel="apple-touch-icon" sizes="180x180" href="<?php echo APP_CLIENT_URL; ?>favicon/apple-icon-180x180.png">
    <link rel="icon" type="image/png" sizes="192x192" href="<?php echo APP_CLIENT_URL; ?>favicon/android-icon-192x192.png">
    <link rel="icon" type="image/png" sizes="32x32" href="<?php echo APP_CLIENT_URL; ?>favicon/favicon-32x32.png">
    <link rel="icon" type="image/png" sizes="96x96" href="<?php echo APP_CLIENT_URL; ?>favicon/favicon-96x96.png">
    <link rel="icon" type="image/png" sizes="16x16" href="<?php echo APP_CLIENT_URL; ?>favicon/favicon-16x16.png">
    <link rel="manifest" href="<?php echo APP_CLIENT_URL; ?>favicon/manifest.json">
    <meta name="msapplication-TileColor" content="#ffffff">
    <meta name="msapplication-TileImage" content="/ms-icon-144x144.png">
    <meta name="theme-color" content="#ffffff">

</head>

<script>
    function toggleSideNav() {
        var pageWrapper = document.getElementsByClassName("page-wrapper")[0];

        if (pageWrapper) {
            if (pageWrapper.getAttribute("data-sidebar-hidden")) {
                pageWrapper.removeAttribute("data-sidebar-hidden");
            } else {
                pageWrapper.setAttribute("data-sidebar-hidden", "hidden");
            }
        }
    }
</script>

<body class="<?php echo $_COOKIE['halfmoon_preferredMode'] ?? 'dark'; ?>">

    <!-- settings -->

    <input id="APP_SERVER_URL" value="<?php echo SERVER_URL; ?>" style="display: none; visibility: hidden;"></input>
    <input id="APP_API_VERSION" value="0.2" style="display: none; visibility: hidden;"></input>

    <input id="APP_CLIENT_PATH" value="<?php echo ADMIN_CLIENT_PATH; ?>" style="display: none; visibility: hidden;"></input>
    <input id="APP_CLIENT_VERSION" value="<?php echo CURRENT_VERSION; ?>" style="display: none; visibility: hidden;"></input>
    <input id="APP_CLIENT_TITLE" value="<?php echo ADMIN_CLIENT_TITLE; ?>" style="display: none; visibility: hidden;"></input>
    <input id="APP_CLIENT_DEBUG" value="<?php echo ADMIN_CLIENT_DEBUG ? '1' : '0'; ?>" style="display: none; visibility: hidden;"></input>

    <div id="app" style="width: 100%; height: 100%;"></div>

</body>

</html>